﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Diagnostics;

namespace SWAT_USB_App
{
    public static class Initialization
    {
        public static string pathToSWATDrive { get; set; }
        public static string computerModel { get; set; }
        public static void Initialize()
        {
            try
            {
                // Pulls information from all drives on the running computer
                DriveInfo[] allDrives = DriveInfo.GetDrives();
                // Looks for a drive with the correct label, updates pathToSWATDrive with the drive letter
                foreach (DriveInfo drive in allDrives)
                {
                    if (drive.IsReady == true)
                        // Drive label for the USB drives is set here.
                        if (
                            ((drive.VolumeLabel.ToUpper() == "SWAT DRIVE X32") 
                            || (drive.VolumeLabel.ToUpper() == "SWAT DRIVE X64")
                            ) && drive.DriveType == DriveType.Removable)
                        {
                            pathToSWATDrive = drive.Name;
                            break;
                        }
                }
                // Prompts for drive to be inserted if none found
                if (pathToSWATDrive == null)
                {
                    DialogResult result;
                    result = MessageBox.Show("Unable to locate the SWAT USB drive.", "Error", MessageBoxButtons.RetryCancel, MessageBoxIcon.Exclamation);
                    if (result == DialogResult.Retry)
                        Initialize();
                    else if (result == DialogResult.Cancel)
                    {
                        if (System.IO.Directory.GetCurrentDirectory() == System.Environment.SystemDirectory)
                        {
                            // If user chooses to remove the program from startup, initializes code to delete the exe after program exits
                            result = MessageBox.Show("Would you like to remove this menu from startup?", "Remove from startup?", MessageBoxButtons.YesNo);
                            if (result == DialogResult.Yes)
                            {
                                // Calls up a hidden command prompt with a timeout of 3 seconds, automatically chooses yes to delete
                                ProcessStartInfo Info = new ProcessStartInfo();
                                Info.Arguments = "/C choice /C Y /N /D Y /T 3 & Del \"" + Application.ExecutablePath + "\"";
                                Info.WindowStyle = ProcessWindowStyle.Hidden;
                                Info.CreateNoWindow = true;
                                Info.FileName = "cmd.exe";
                                Process.Start(Info);
                                Environment.Exit(1);
                            }
                            else
                                Environment.Exit(1);
                        }
                    }
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
            }
        }
        public static void GetModelNumber()
        {
            // Pulls the model nubmer of the computer using systeminfo.exe
            try
            {
                Process proc = new Process();
                proc.StartInfo.WorkingDirectory = System.Environment.SystemDirectory;
                proc.StartInfo.FileName = "systeminfo.exe";
                proc.StartInfo.UseShellExecute = false;
                proc.StartInfo.RedirectStandardOutput = true;
                proc.StartInfo.CreateNoWindow = true;
                proc.Start();
                string output = "";
                for (int i = 0; i < 14; i++)
                    output = proc.StandardOutput.ReadLine();
                computerModel = output.Substring(27);
            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
            }
        }
    }
}